% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_player_leaderboard.R
\name{bart_player_leaderboard}
\alias{bart_player_leaderboard}
\title{Player Leaderboard}
\usage{
bart_player_leaderboard(
  stat = NULL,
  year = NULL,
  agg = "mean",
  span = "career",
  num_players = 25,
  min_games = NULL,
  min_minutes = NULL,
  exp = NULL,
  team = NULL,
  conf = NULL,
  id = NULL,
  ...
)
}
\arguments{
\item{stat}{Stat to return (see details)}

\item{year}{Filters to yer -- only with \code{season} span}

\item{agg}{Return \code{mean} or \code{sum} data}

\item{span}{Return \code{season} or \code{career} data}

\item{num_players}{Number of players to return (defaults to 25)}

\item{min_games}{Minimum games}

\item{min_minutes}{Minimum minutes}

\item{exp}{Experience to filter}

\item{team}{Team to filter}

\item{conf}{Conference to filter}

\item{id}{Player id}

\item{...}{Other API parameters. Used for future expansion.}
}
\value{
Returns a tibble.
}
\description{
Returns season or career stat leaders for a given statistic
}
\details{
Available statistics to pass through to \code{stat}:\tabular{ll}{
   stat \tab agg \cr
   min \tab both \cr
   pts \tab both \cr
   fg_pct \tab mean \cr
   efg \tab mean \cr
   ts \tab mean \cr
   two_m \tab both \cr
   two_a \tab both \cr
   three_m \tab both \cr
   three_a \tab both \cr
   ftm \tab both \cr
   fta \tab both \cr
   dunk_m \tab both \cr
   dunk_a \tab both \cr
   rim_m \tab both \cr
   rim_a \tab both \cr
   mid_m \tab both \cr
   mid_a \tab both \cr
   oreb \tab both \cr
   dreb \tab both \cr
   reb \tab both \cr
   ast \tab both \cr
   tov \tab both \cr
   ast_tov \tab mean \cr
   stl \tab both \cr
   blk \tab both \cr
   pf \tab both \cr
   ortg \tab mean \cr
   usg \tab mean \cr
   or_pct \tab mean \cr
   dr_pct \tab mean \cr
   ast_pct \tab mean \cr
   to_pct \tab mean \cr
   stl_pct \tab mean \cr
   blk_pct \tab mean \cr
   bpm \tab mean \cr
   obpm \tab mean \cr
   dbpm \tab mean \cr
   net \tab mean \cr
}
}
\examples{
\donttest{try(bart_player_leaderboard('pts'))}
}
