% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_poy.R
\name{bart_poy}
\alias{bart_poy}
\title{Get Player of the Year Ratings}
\usage{
bart_poy(
  year = current_season(),
  conf = "All",
  class = NULL,
  conf_only = FALSE
)
}
\arguments{
\item{year}{Defaults to current season (YYYY).}

\item{conf}{Filters results by conference; defaults to all (see details).}

\item{class}{Filters results by class ('fr', 'so', 'jr', 'sr'); defaults to
no filter.}

\item{conf_only}{Logical. Filters data by conference-only play; defaults to
`FALSE`.}
}
\value{
Returns a tibble with four columns:
\describe{
  \item{\code{rk}}{integer.}
  \item{\code{player}}{character.}
  \item{\code{team}}{character.}
  \item{\code{score}}{double.}
  }
}
\description{
Returns Barttorvik Player of the Year ratings on a variety of splits.
}
\details{
Accepted conference abbreviations for the `conf` argument are: \itemize{\item
‘A10’, ‘ACC’, ‘AE’, ‘ASun’, ‘Amer’, ‘B10’, ‘B12’, ‘BE’, ‘BSky’, ‘BSth’, ‘BW’,
‘CAA’, ‘CUSA’, ‘Horz’, ‘Ivy’, ‘MAAC’, ‘MAC’, ‘MEAC’, ‘MVC’, ‘MWC’, ‘NEC’,
‘OVC’, ‘P12’, ‘Pat’, ‘SB’, ‘SC’, ‘SEC’, ‘SWAC’, ‘Slnd’, ‘Sum’, ‘WAC’, ‘WCC’ }
}
\examples{
\donttest{try(bart_poy(year=2019, class='fr'))}

}
