% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_recruiting_rankings.R
\name{team_recruiting_rankings}
\alias{team_recruiting_rankings}
\title{Get Team Recruiting Rankings}
\usage{
team_recruiting_rankings(year = NULL, conf = NULL, team = NULL, ...)
}
\arguments{
\item{year}{Freshman season for class (class year + 1)}

\item{conf}{Conference to filter for}

\item{team}{Team to filter for}

\item{...}{Any other parameter accepted by the API endpoint}
}
\value{
Returns a tibble with 31 columns: \describe{
  \item{\code{year}}{integer.}
  \item{\code{team}}{character.}
  \item{\code{conf}}{character.}
  \item{\code{rank}}{integer.}
  \item{\code{comp_rank}}{integer. Composite national team ranking.}
  \item{\code{conf_rank}}{double.}
  \item{\code{comp_conf_rank}}{double. Composite conference team ranking.}
  \item{\code{avg_rating}}{double. Average commit rating.}
  \item{\code{avg_comp_rating}}{double. Average commit composite rating.}
  \item{\code{rating}}{double. 247Sports class rating.}
  \item{\code{comp_rating}}{double. 247Sports composite class rating.}
  \item{\code{five_stars}}{integer.}
  \item{\code{comp_five_stars}}{double.}
  \item{\code{four_stars}}{integer.}
  \item{\code{comp_four_stars}}{double.}
  \item{\code{three_stars}}{integer.}
  \item{\code{comp_three_stars}}{double.}
  \item{\code{commits}}{integer.}}
}
\description{
Returns team rankings for 247Sports
}
\details{
Function pulls national and conference ranking for 247Sports recruiting back
to 2011
}
\examples{
\donttest{try(team_recruiting_rankings(year=2022))}

}
