% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivtobit.R
\name{ivtobit}
\alias{ivtobit}
\title{Simultaneous-equation tobit model}
\usage{
ivtobit(
  formula,
  data,
  subset = NULL,
  left = 0,
  right = Inf,
  method = c("ml", "2steps"),
  robust = TRUE,
  trace = 0
)
}
\arguments{
\item{formula}{a symbolic description of the model,}

\item{data}{a data frame,}

\item{subset}{a subset,}

\item{left, right}{left and right limits of the dependent
variable. The default is respectively 0 and +Inf which
corresponds to the most classic (left-zero truncated) tobit
model,}

\item{method}{one of \code{"ml"} for maximum likelihood, "2steps"`,}

\item{robust}{a boolean, if \code{TRUE}, a consistent estimation of the
covariance of the coefficients is used for the 2-steps method,}

\item{trace}{a boolean (the default if \code{FALSE}) if \code{TRUE} some
information about the optimization process is printed,}
}
\value{
An object of class \code{c('tobit1', 'lm')}, see \code{tobit1::tobit1} for more details.
}
\description{
Estimation of simultaneous-equation models when the response is
trunctaed
}
\examples{
inst <- ~ sic3 + k_serv + inv + engsci + whitecol + skill + semskill + cropland + 
    pasture + forest + coal + petro + minerals + scrconc + bcrconc + scrcomp + bcrcomp + meps + 
    kstock + puni + geog2 + tenure + klratio + bunion
tradeprotection <- dplyr::mutate(tradeprotection,
                                 y = ntb / (1 + ntb),
                                 x1 = exports / imports / elast,
                                 x2 = cap * x1)
GH <- ivtobit(Formula::as.Formula(y  ~  x1 + x2, inst), tradeprotection, method = "2steps") 
Full <- ivtobit(Formula::as.Formula(y ~ x1 + x2 + labvar, inst), tradeprotection, method = "2steps") 
Short <- ivtobit(Formula::as.Formula(y ~ x1 + I(x2 + labvar), inst),
                 tradeprotection, method = "2steps") 
}
\references{
\insertRef{SMIT:BLUN:86}{tobit1}
}
\author{
Yves Croissant
}
