\name{river}
\alias{river}
\title{Identification of rivers in a digital elevation model}
\description{
  This function identifies river headwater cells based on threshold
  values in a topographic index and accumulated area river (generated
  using \code{topidx}. Rivers are then traced downslope using a single flow algorithm.
}
\usage{
  river(DEM,atb,area,res,thatb,tharea)
}
\arguments{
  \item{DEM}{A matrix representing a digital elevation model [m] with equally sized pixels and equal NS and EW resolution}
  \item{atb}{Matrix with topographic index values generated by \code{topidx}}
  \item{area}{Matrix with drainage area values generated by \code{topidx}}
  \item{res}{Resolution of the digital elevation model (m)}
  \item{thatb}{A topographic index threshold for headwater cells}
  \item{tharea}{A drainage threshold for headwater cells}
}
\details{
If thatb or tharea are exceeded in the respective maps, cells are identified as headwater cells. The routine then traces down rivers from these cells based on a D8 algorithm and calculates the distance towards the outlet. Outlets are recognized by sinks, map borders or excluded areas (NA). The \code{subcatch} function can be used to set areas outside the target catchment to NA.
}

\value{A matrix of the same size as DEM.}

\references{See \url{http://wiki.r-project.org/rwiki/doku.php?id=guides:tutorials:hydrological_data_analysis} for examples.}

\author{Wouter Buytaert, Imperial College London, based on an implementation from the Hydrology Group of Lancaster University}
%\note{}

\seealso{\code{\link{subcatch}}, \code{\link{topidx}}}
%\examples{}
%\keyword{}
