% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_triu}
\alias{torch_triu}
\title{Triu}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{diagonal}{(int, optional) the diagonal to consider}

\item{out}{(Tensor, optional) the output tensor.}
}
\description{
Triu
}
\section{triu(input, diagonal=0, out=None) -> Tensor }{


Returns the upper triangular part of a matrix (2-D tensor) or batch of matrices
\code{input}, the other elements of the result tensor \code{out} are set to 0.

The upper triangular part of the matrix is defined as the elements on and
above the diagonal.

The argument \code{diagonal} controls which diagonal to consider. If
\code{diagonal} = 0, all elements on and above the main diagonal are
retained. A positive value excludes just as many diagonals above the main
diagonal, and similarly a negative value includes just as many diagonals below
the main diagonal. The main diagonal are the set of indices
\eqn{\lbrace (i, i) \rbrace} for \eqn{i \in [0, \min\{d_{1}, d_{2}\} - 1]} where
\eqn{d_{1}, d_{2}} are the dimensions of the matrix.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(3, 3))
a
torch_triu(a)
torch_triu(a, diagonal=1)
torch_triu(a, diagonal=-1)
b = torch_randn(c(4, 6))
b
torch_triu(b, diagonal=1)
torch_triu(b, diagonal=-1)
}
}
