% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creation-ops.R, R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_full}
\alias{torch_full}
\title{Full}
\usage{
torch_full(
  size,
  fill_value,
  names = NULL,
  dtype = NULL,
  layout = NULL,
  device = NULL,
  requires_grad = FALSE
)
}
\arguments{
\item{size}{(int...) a list, tuple, or \code{torch_Size} of integers defining the        shape of the output tensor.}

\item{fill_value}{NA the number to fill the output tensor with.}

\item{names}{optional names of the dimensions}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned tensor.        Default: if \code{NULL}, uses a global default (see \code{torch_set_default_tensor_type}).}

\item{layout}{(\code{torch.layout}, optional) the desired layout of returned Tensor.        Default: \code{torch_strided}.}

\item{device}{(\code{torch.device}, optional) the desired device of returned tensor.        Default: if \code{NULL}, uses the current device for the default tensor type        (see \code{torch_set_default_tensor_type}). \code{device} will be the CPU        for CPU tensor types and the current CUDA device for CUDA tensor types.}

\item{requires_grad}{(bool, optional) If autograd should record operations on the        returned tensor. Default: \code{FALSE}.}
}
\description{
Full
}
\section{full(size, fill_value, out=NULL, dtype=NULL, layout=torch.strided, device=NULL, requires_grad=False) -> Tensor }{


Returns a tensor of size \code{size} filled with \code{fill_value}.
}

\section{Warning}{

In PyTorch 1.5 a bool or integral \code{fill_value} will produce a warning if
\code{dtype} or \code{out} are not set.
In a future PyTorch release, when \code{dtype} and \code{out} are not set
a bool \code{fill_value} will return a tensor of torch.bool dtype,
and an integral \code{fill_value} will return a tensor of torch.long dtype.
}

\examples{
if (torch_is_installed()) {

torch_full(list(2, 3), 3.141592)
}
}
