% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_is_nonzero}
\alias{torch_is_nonzero}
\title{Is_nonzero}
\usage{
torch_is_nonzero(self)
}
\arguments{
\item{self}{(Tensor) the input tensor.}
}
\description{
Is_nonzero
}
\section{is_nonzero(input) -> (bool) }{


Returns TRUE if the \code{input} is a single element tensor which is not equal to zero
after type conversions.
i.e. not equal to \code{torch_tensor(c(0))} or \code{torch_tensor(c(0))} or
\code{torch_tensor(c(FALSE))}.
Throws a \code{RuntimeError} if \code{torch_numel() != 1} (even in case
of sparse tensors).
}

\examples{
if (torch_is_installed()) {

torch_is_nonzero(torch_tensor(c(0.)))
torch_is_nonzero(torch_tensor(c(1.5)))
torch_is_nonzero(torch_tensor(c(FALSE)))
torch_is_nonzero(torch_tensor(c(3)))
if (FALSE) {
torch_is_nonzero(torch_tensor(c(1, 3, 5)))
torch_is_nonzero(torch_tensor(c()))
}
}
}
