% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_trapz}
\alias{torch_trapz}
\title{Trapz}
\usage{
torch_trapz(y, dx = 1L, x, dim = -1L)
}
\arguments{
\item{y}{(Tensor) The values of the function to integrate}

\item{dx}{(float) The distance between points at which \code{y} is sampled.}

\item{x}{(Tensor) The points at which the function \code{y} is sampled.        If \code{x} is not in ascending order, intervals on which it is decreasing        contribute negatively to the estimated integral (i.e., the convention        \eqn{\int_a^b f = -\int_b^a f} is followed).}

\item{dim}{(int) The dimension along which to integrate.        By default, use the last dimension.}
}
\description{
Trapz
}
\section{trapz(y, x, *, dim=-1) -> Tensor }{


Estimate \eqn{\int y\,dx} along \code{dim}, using the trapezoid rule.
}

\section{trapz(y, *, dx=1, dim=-1) -> Tensor }{


As above, but the sample points are spaced uniformly at a distance of \code{dx}.
}

\examples{
if (torch_is_installed()) {

y = torch_randn(list(2, 3))
y
x = torch_tensor(matrix(c(1, 3, 4, 1, 2, 3), ncol = 3, byrow=TRUE))
torch_trapz(y, x = x)

}
}
