% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-dropout.R
\name{nn_dropout2d}
\alias{nn_dropout2d}
\title{Dropout2D module}
\usage{
nn_dropout2d(p = 0.5, inplace = FALSE)
}
\arguments{
\item{p}{(float, optional): probability of an element to be zero-ed.}

\item{inplace}{(bool, optional): If set to \code{TRUE}, will do this operation
in-place}
}
\description{
Randomly zero out entire channels (a channel is a 2D feature map,
e.g., the \eqn{j}-th channel of the \eqn{i}-th sample in the
batched input is a 2D tensor \eqn{\mbox{input}[i, j]}).
}
\details{
Each channel will be zeroed out independently on every forward call with
probability \code{p} using samples from a Bernoulli distribution.
Usually the input comes from \link{nn_conv2d} modules.

As described in the paper
\href{https://arxiv.org/abs/1411.4280}{Efficient Object Localization Using Convolutional Networks} ,
if adjacent pixels within feature maps are strongly correlated
(as is normally the case in early convolution layers) then i.i.d. dropout
will not regularize the activations and will otherwise just result
in an effective learning rate decrease.
In this case, \link{nn_dropout2d} will help promote independence between
feature maps and should be used instead.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, C, H, W)}
\item Output: \eqn{(N, C, H, W)} (same shape as input)
}
}

\examples{
if (torch_is_installed()) {
m <- nn_dropout2d(p = 0.2)
input <- torch_randn(20, 16, 32, 32)
output <- m(input)

}
}
