% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_dither}
\alias{functional_dither}
\title{Dither (functional)}
\usage{
functional_dither(waveform, density_function = "TPDF", noise_shaping = FALSE)
}
\arguments{
\item{waveform}{(Tensor): Tensor of audio of dimension (..., time)}

\item{density_function}{(str, optional): The density function of a continuous random variable (Default: \code{"TPDF"})
Options: Triangular Probability Density Function - \code{TPDF}
Rectangular Probability Density Function - \code{RPDF}
Gaussian Probability Density Function - \code{GPDF}}

\item{noise_shaping}{(bool, optional): a filtering process that shapes the spectral
energy of quantisation error  (Default: \code{FALSE})}
}
\value{
\code{tensor}: waveform dithered
}
\description{
Dither increases the perceived dynamic range of audio stored at a
particular bit-depth by eliminating nonlinear truncation distortion
(i.e. adding minimally perceived noise to mask distortion caused by quantization).
}
