% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_flanger}
\alias{functional_flanger}
\title{Flanger Effect (functional)}
\usage{
functional_flanger(
  waveform,
  sample_rate,
  delay = 0,
  depth = 2,
  regen = 0,
  width = 71,
  speed = 0.5,
  phase = 25,
  modulation = "sinusoidal",
  interpolation = "linear"
)
}
\arguments{
\item{waveform}{(Tensor): audio waveform of dimension of \verb{(..., channel, time)} .
Max 4 channels allowed}

\item{sample_rate}{(int): sampling rate of the waveform, e.g. 44100 (Hz)}

\item{delay}{(float): desired delay in milliseconds(ms).
Allowed range of values are 0 to 30}

\item{depth}{(float): desired delay depth in milliseconds(ms).
Allowed range of values are 0 to 10}

\item{regen}{(float): desired regen(feeback gain) in dB.
Allowed range of values are -95 to 95}

\item{width}{(float):  desired width(delay gain) in dB.
Allowed range of values are 0 to 100}

\item{speed}{(float):  modulation speed in Hz.
Allowed range of values are 0.1 to 10}

\item{phase}{(float):  percentage phase-shift for multi-channel.
Allowed range of values are 0 to 100}

\item{modulation}{(str):  Use either "sinusoidal" or "triangular" modulation. (Default: \code{sinusoidal})}

\item{interpolation}{(str): Use either "linear" or "quadratic" for delay-line interpolation. (Default: \code{linear})}
}
\value{
\code{tensor}: Waveform of dimension of \verb{(..., channel, time)}
}
\description{
Apply a flanger effect to the audio. Similar to SoX implementation.
}
\references{
\itemize{
\item \url{https://sox.sourceforge.net/sox.html}
\item Scott Lehman, Effects Explained, \url{https://web.archive.org/web/20051125072557/http://www.harmony-central.com/Effects/effects-explained.html}
}
}
