% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.meta.R
\name{as.meta}
\alias{as.meta}
\title{"meta" Component of "textmeta"-Objects}
\usage{
as.meta(
  x,
  cols = colnames(x),
  idCol = "id",
  dateCol = "date",
  titleCol = "title",
  dateFormat
)
}
\arguments{
\item{x}{data.frame to convert}

\item{cols}{\code{character} vector with columns which should be kept}

\item{idCol}{\code{character} string with column name of the IDs}

\item{dateCol}{\code{character} string with column name of the Dates}

\item{titleCol}{\code{character} string with column name of the Titles}

\item{dateFormat}{\code{character} string with the date format in x for \code{\link{as.Date}}.
If not supplied, dates are not transformed.}
}
\value{
A data.frame with columns "id", "date", "title" and user-specified others.
}
\description{
Helper to create the requested data.frame to create a "textmeta" object.
}
\examples{
meta <- data.frame(id = 1:3, additionalVariable = matrix(5, ncol = 4, nrow = 3))
(as.meta(meta))

}
\keyword{manip}
