% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.textmeta.R
\name{tidy.textmeta}
\alias{tidy.textmeta}
\alias{is.textmeta_tidy}
\alias{print.textmeta_tidy}
\title{Transform textmeta to an object with tidy text data}
\usage{
tidy.textmeta(object)

is.textmeta_tidy(x)

\method{print}{textmeta_tidy}(x, ...)
}
\arguments{
\item{object}{A \code{\link{textmeta}} object}

\item{x}{an R Object.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object with tidy text data
}
\description{
Transfers data from a text component of a \code{\link{textmeta}} object to a
tidy data.frame.
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
 Teach a Man To Fish, and You Feed Him for a Lifetime",
 B="So Long, and Thanks for All the Fish",
 C="A very able manipulative mathematician, Fisher enjoys a real mastery
 in evaluating complicated multiple integrals.")

obj <- textmeta(meta=data.frame(id=c("A", "B", "C", "D"),
 title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
 date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
 additionalVariable=1:4, stringsAsFactors=FALSE), text=texts)

tidy.textmeta(obj)

obj <- cleanTexts(obj)
tidy.textmeta(obj)
}
\keyword{manip}
