% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{xdg_data_home}
\alias{xdg_data_home}
\title{Get XDG_DATA_HOME}
\usage{
xdg_data_home(sep = "/", fallback = normalizePath(getwd(), winslash = sep))
}
\arguments{
\item{sep}{Path separator to be used on Windows}

\item{fallback}{Value to return as fallback (see details)}
}
\value{
The following algorithm is used to determine the returned path:
\enumerate{
\item If environment variable (EV) \verb{$XDG_DATA_HOME} exists, return its value
\item Else, if EV \verb{$HOME} exists, return \verb{$HOME/.local/share}
\item Else, if EV \verb{$USERPROFILE} exists, return \verb{$USERPROFILE/.local/share}
\item Else, return \verb{$fallback}
}
}
\description{
Return value for XDG_DATA_HOME as defined by the \href{https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html}{XDG Base Directory Specification}
}
\examples{
xdg_data_home()
}
\seealso{
\code{\link[=xdg_config_home]{xdg_config_home()}}
}
\keyword{path}
