% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path-dist.r
\name{path_dist}
\alias{path_dist}
\title{Compute distance matrix from bases.}
\usage{
path_dist(history)
}
\arguments{
\item{history}{history of the plots}
}
\description{
Compute distance matrix from bases.
}
\examples{
# This code is to be used as an example but you should increase
# the max from 2 to 50, say, to check tour coverage.
grand <- interpolate(save_history(flea[, 1:6], max = 2), 0.2)
# The grand tour  -----------------------------
# Look at the tour path in a tour, how well does it cover a sphere
# Using MDS to summarise the high-d space of projections
d <- path_dist(grand)
ord <- as.data.frame(MASS::isoMDS(d)$points)
require(ggplot2)
ggplot(data = ord, aes(x=V1, y=V2)) +
  geom_path() +
  coord_equal() +
  labs(x = NULL, y = NULL)

# Compare five guided tours  -----------------------------
holes1d <- guided_tour(holes(), 1)
tour_reps <- replicate(5, save_history(flea[, 1:6], holes1d, max = 2),
  simplify = FALSE
)
tour_reps2 <- lapply(tour_reps, interpolate, 0.2)

bases <- unlist(lapply(tour_reps2, as.list), recursive = FALSE)
class(bases) <- "history_list"
index_values <- paths_index(tour_reps2, holes())
d <- path_dist(bases)
ord <- as.data.frame(cmdscale(d, 2))

info <- cbind(ord, index_values)
if (require("ggplot2")) {
  ggplot(data = info, aes(x = step, y = value, group = try)) +
    geom_line()
  ##ggplot(data = info, aes(x = V1, y = V2, group = try)) +
  ##  geom_path() +
  ##  geom_point(aes(size = value)) +
  ##  coord_equal()
  ##last_plot() + facet_wrap(~try)
}
}
