% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display-pca.r
\name{display_pca}
\alias{display_pca}
\alias{animate_pca}
\title{Display tour path with principal component scores with original axes}
\usage{
display_pca(
  center = TRUE,
  axes = "center",
  half_range = NULL,
  col = "black",
  pch = 20,
  cex = 1,
  pc_coefs = NULL,
  edges = NULL,
  edges.col = "black",
  palette = "Zissou 1",
  ...
)

animate_pca(data, tour_path = grand_tour(), rescale = FALSE, ...)
}
\arguments{
\item{center}{if TRUE, centers projected data to (0,0).  This pins the
center of data cloud and make it easier to focus on the changing shape
rather than position.}

\item{axes}{position of the axes: center, bottomleft or off}

\item{half_range}{half range to use when calculating limits of projected.
If not set, defaults to maximum distance from origin to each row of data.}

\item{col}{color to use for points, can be a vector or hexcolors or a factor.  Defaults to "black".}

\item{pch}{shape of the point to be plotted.  Defaults to 20.}

\item{cex}{size of the point to be plotted.  Defaults to 1.}

\item{pc_coefs}{coefficients relating the original variables to
principal components. This is required.}

\item{edges}{A two column integer matrix giving indices of ends of lines.}

\item{edges.col}{colour of edges to be plotted, Defaults to "black.}

\item{palette}{name of color palette for point colour, used by \code{\link{hcl.colors}}, default "Zissou 1"}

\item{...}{other arguments passed on to \code{\link{animate}} and
\code{\link{display_slice}}}

\item{data}{matrix, or data frame containing numeric columns}

\item{tour_path}{tour path generator, defaults to 2d grand tour}

\item{rescale}{Default FALSE. If TRUE, rescale all variables to range [0,1].}
}
\description{
Animate a 2D tour path on data that has been transformed into
principal components, and also show the original variable axes.
}
\examples{
flea_std <- apply(flea[,1:6], 2, function(x) (x-mean(x))/sd(x))
flea_pca <- prcomp(flea_std, center = FALSE, )
flea_coefs <- flea_pca$rotation[, 1:3]
flea_scores <- flea_pca$x[, 1:3]
animate_pca(flea_scores, pc_coefs = flea_coefs)
}
