% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trackr-main-API.R
\name{record}
\alias{record}
\alias{rmRecord}
\alias{findRecords}
\title{Primary high-level API functions for Trackr Databases}
\usage{
record(object, db = defaultTDB(), resultURI = "", code = histry::histry(),
  force = FALSE, verbose = FALSE, symorpos = NULL)

rmRecord(object, db = defaultTDB(), verbose = FALSE)

findRecords(pattern, db = defaultTDB(), fields = NULL,
  ret_type = c("doclist", "id", "backend"), verbose = FALSE)
}
\arguments{
\item{object}{ANY. A PlotFeatureSet (or plot object coercible to one) to be
added. Or (for rmPlot) the unique ID of an object in the database to remove.}

\item{db}{TrackrDB. The database}

\item{resultURI}{A URI which can be used to define a grouping/hierarchy of results recorded via trackr. Currently unused by trackr itself except as additional metadata to search across. Defaults to an empty string.}

\item{code}{ANY. Code/evaluation history to be associated with \code{object}}

\item{force}{logical. Overwrite any existing entry matching \code{object}.
(default: FALSE)}

\item{verbose}{logical. Should extra informative messages be displayed (
default: FALSE)}

\item{symorpos}{The symbol or position corresponding to \code{object} in \code{code}. For normal usage this will not be required.}

\item{pattern}{character. A regular expression to match against the text in \code{fields}}

\item{fields}{character or NULL. The fiends in which to match, or NULL to
include all fields.}

\item{ret_type}{character. Format in which to return the response. Options are:
"id" - id of matching documents (default), "list" - A list containing the
matching documents represnted as R lists, and "backend" - a backend specific
representation of the set of matching documents}
}
\description{
These functions define the high-level, user-facing trackr API.
}
\details{
These functions allow end-users to interact with
trackr databases. Each function does what its name suggests.
}
\examples{
prevtdb = defaultTDB()
defaultTDB(listTDB())
mt = mtcars
record(mt)

res = findRecords("mtcars")
stopifnot(length(res) ==1)
rmRecord(mt)

res = findRecords("mtcars")
stopifnot(length(res) == 0)
defaultTDB(prevtdb)

}
