% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kin.2d.R
\name{amp.freq}
\alias{amp.freq}
\title{Computes amplitude and frequency of wave-like data}
\usage{
amp.freq(x = NULL, y, sf = 100)
}
\arguments{
\item{x}{Numeric; x position (or sample number)}

\item{y}{numeric; y position}

\item{sf}{numeric; sample frequency (i.e., how often was x and y sampled) in Hz}
}
\value{
a list with amplitude "a", frequency "f", amplitude returned from a smoothed sign function "a.f" based on output from \code{features}, signal to noise ratio "snr".
}
\description{
Computes amplitude(s) and wavelength(s) of a wave form, amongst other things, based on a sampling frequency
}
\examples{
\dontrun{
#Compute waveform patterns
x <- seq(0,pi,0.1)
y <- sin(x^1.3*pi)
plot(x,y)

amp.freq(x=x,y=y)
}
}
\seealso{
\code{\link{features}}
}
