% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffmpeg.R
\name{images.to.video2}
\alias{images.to.video2}
\title{Stitches images from video file passing filters to ffmpeg}
\usage{
images.to.video2(
  image.dir = NULL,
  out.dir = NULL,
  vid.name = NULL,
  overwrite = TRUE,
  qual = 50,
  vid.ext = ".mp4",
  frame.rate = 10,
  raw = TRUE,
  filt = NULL,
  silent = TRUE
)
}
\arguments{
\item{image.dir}{character; directory containing images to stitch.}

\item{out.dir}{character; directory in which to store video.}

\item{vid.name}{character; file name to be given video (should not include file extension).}

\item{overwrite}{logical; should path described by vid.name  be overwritten if it exhists.}

\item{qual}{numeric; the quality of the video rendered from 1-100\%. Defaults to 50\%.}

\item{vid.ext}{character; video type to output. mp4 currently works best.}

\item{frame.rate}{numeric; video frame rate in fps.}

\item{raw}{logical; encodes a raw AVI video with the "rawvideo" codec.}

\item{filt}{character; video filter that should be applied to ffmpeg operation. See \url{https://ffmpeg.org/ffmpeg-filters.html}.}

\item{silent}{logical; should output of \code{system} call for ffmpeg operation be suppressed.}
}
\value{
Outputs a video of name "video.name+vid.ext".
}
\description{
Wrapper for ffmpeg video operations. Permits flexible filtering.
}
\details{
Assumes images are appended with a numeric sequence beginning with "_".
}
\examples{

#make some spiralled images and video

\donttest{
dir.create(paste0(tempdir(),"/images")) #make a directory to store images

a <- 2
b <- 3
theta <- seq(0,10*pi,0.01)
r <- a + b*theta
df <- data.frame(x=r*cos(theta), y=r*sin(theta)) # Cartesian coords
every.i <- 30
for(i in seq(1,length(theta),30)) {
  jpeg(paste0(tempdir(),"/images/image_",sprintf("\%03d",which(i==seq(1,length(theta),30))),".jpg"))
  with(df[1:i,],plot(x,y,xlim=range(df$x),ylim=range(df$y),col="red"))
  dev.off()
  }

images.to.video2(image.dir=paste0(tempdir(),"/images"),
vid.name="spiral",out.dir=tempdir(),
frame.rate=5,qual=100,silent=TRUE,overwrite=TRUE)

file.exists(paste0(tempdir(),"/spiral.mp4"))

#clean up
unlink(paste0(tempdir(),"/images"),recursive=TRUE)
}
}
\seealso{
\code{\link{vid.to.images2}}
}
