% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{plot.tramME}
\alias{plot.tramME}
\title{Plotting method for tramME objects}
\usage{
\method{plot}{tramME}(
  x,
  newdata = model.frame(x),
  ranef = NULL,
  fix_smooth = TRUE,
  type = c("trafo", "distribution", "logdistribution", "survivor", "logsurvivor",
    "density", "logdensity", "hazard", "loghazard", "cumhazard", "logcumhazard", "odds",
    "logodds", "quantile"),
  ...
)
}
\arguments{
\item{x}{A \code{tramME} object.}

\item{newdata}{an optional data frame of observations}

\item{ranef}{Random effects (either in named list format or a numeric vector)
or the word "zero". See Details.}

\item{fix_smooth}{If \code{FALSE}, the random effects coefficients of the smooth
terms are refitted to \code{newdata}. It's probably not what you want to do.}

\item{type}{The scale on which the predictions are evaluated:
\itemize{
  \item trafo: The prediction evaluated on the scale of the
    transformation function.
  \item (log)distribution: The prediction evaluated on the scale of the
    conditional (log-)CDF.
  \item (log)survivor: The prediction evaluated on the scale of the
    (conditional) (log-)survivor function.
  \item (log)density: The prediction evaluated on the scale of
    the conditional (log-)PDF.
  \item (log)hazard: The prediction evaluated on the (log-)hazard scale.
  \item (log)cumhazard: The prediction evaluated on the (log-)cumulative
    hazard scale.
  \item (log)odds: The prediction evaluated on the (log-)odds scale.
  \item quantile: Return the quantiles of the conditional outcome distribution
    corresponding to \code{newdata}. For more information, see Details.
}}

\item{...}{Additional arguments, passed to \code{\link[mlt]{plot.mlt}}.}
}
\value{
A numeric matrix of the predicted values invisibly.
}
\description{
Plot the conditional distribution evaluated at a grid of possible response
values and a set of covariate and random effects values on a specified scale.
}
\details{
When \code{ranef} is equal to "zero", a vector of zeros with the right size is
substituted. For more details, see \code{\link[tramME]{predict.tramME}}.

For more information on how to control the grid on which the functions are evaluated,
see the documentation of \code{\link[mlt]{predict.mlt}}.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
plot(fit, K = 100, type = "density")
}
