% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssFilter.R
\name{xpssFilter}
\alias{xpssFilter}
\title{Creates a FILTER subset}
\usage{
xpssFilter(x,variable = NULL, filtervalue = 1)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}

\item{variable}{atomic character with the name of the variable.}

\item{filtervalue}{atomic character or atomic numeric which contains the filtervalue.}
}
\value{
Output is a subset of the actual dataset under the predetermined condition of the filtervalue.
}
\description{
R implementation of the SPSS \code{FILTER} argument.
}
\details{
\code{xpssFilter} creates a subset of the actual dataset, without deleting the excluded variables, respectively without deleting the excluded values. After activating \code{xpssFilter}, only the subset will be used, the excluded data will be ignored for the following actions until  \code{\link{xpssFilterOff}} terminates the filtering. As noted before those cases are \strong{not actually} deleted and will be available after the filter is turned off.
\cr\cr \strong{Important:}
\cr All changes are used on the complete dataset, except for the function being an \emph{data exploring} or \emph{data analyzing} function \cr \cr
 \tabular{rlll}{
 \tab Type of Function \tab Example Function \tab Dataset Usage \cr
\tab Data Management  \tab \code{\link{xpssSelectIf}} \tab Uses thecomplete dataset\cr
\tab Data Modifing \tab \code{\link{xpssRecode}} \tab Uses the complete dataset\cr
\tab Data Exploring \tab \code{\link{xpssDescriptives}} \tab Uses theworking dataset only\cr
\tab Data Analyzing \tab \code{\link{xpssRegression}} \tab Uses the working dataset only\cr
}
}
\examples{
data(fromXPSS)

fromXPSS <- xpssFilter(x=fromXPSS, variable = "V3", filtervalue=1)

xpssDescriptives(x=fromXPSS, variables = "V6")

xpssFilterOff(x=fromXPSS)
}
\author{
Bastian Wiessner
}
\seealso{
Related Functions \code{\link{xpssDoIf}} \code{\link{xpssFilterOff}} \code{\link{xpssSample}} \code{\link{xpssSelectIf}} \code{\link{xpssTemporary}}
}

