% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-text.R
\name{text}
\alias{text}
\alias{is_text}
\alias{format.Text}
\alias{print.Text}
\alias{c.Text}
\alias{merge_texts}
\alias{as_text}
\alias{as_text.call}
\alias{Text}
\title{Source Text}
\usage{
text(
  ...,
  source_lang = language_source_get(),
  algorithm = constant("algorithms")
)

is_text(x)

\method{format}{Text}(x, ...)

\method{print}{Text}(x, ...)

\method{c}{Text}(...)

merge_texts(..., algorithm = constant("algorithms"))

as_text(x, ...)

\method{as_text}{call}(
  x,
  strict = FALSE,
  location = transltr::location(),
  algorithm = constant("algorithms"),
  validate = TRUE,
  ...
)
}
\arguments{
\item{...}{Usage depends on the underlying function.
\itemize{
\item Any number of \code{\link{Location}} objects and/or named character
strings for \code{\link[=text]{text()}} (in no preferred order).
\item Any number of \code{\link{Text}} objects for \code{\link[=merge_texts]{merge_texts()}} and S3
method \code{\link[=c]{c()}}.
\item Further arguments passed to or from other methods for \code{\link[=format]{format()}},
\code{\link[=print]{print()}}, and \code{\link[=as_text]{as_text()}}.
}}

\item{source_lang}{A non-empty and non-\link[base:NA]{NA} character string. The
language of the (untranslated) source text.

A language is usually a code (of two or three letters) for a native
language name. While users retain full control over codes, it is best
to use language codes stemming from well-known schemes such as
\href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47}, or
\href{https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes}{ISO 639-1}.
Doing so maximizes portability and cross-compatibility between packages.}

\item{algorithm}{A non-empty and non-\link[base:NA]{NA} character string
equal to \code{"sha1"}, or \code{"utf8"}. The algorithm to use when hashing
source information for identification purposes.}

\item{x}{Any \R object.}

\item{strict}{A non-\link[base:NA]{NA} logical value. Should only
\emph{explicit calls}, i.e. \code{transltr::translate()}, be extracted? If \code{FALSE},
calls to \emph{any} such function are extracted regardless of the underlying
namespace, i.e. \code{translate()}.}

\item{location}{A \code{\link{Location}} object.}

\item{validate}{A non-\link[base:NA]{NA} logical value. Should the arguments be
validated before being used? This argument should be left as is.}
}
\value{
\code{\link[=text]{text()}}, \code{\link[=c]{c()}}, and \code{\link[=as_text]{as_text()}} return an \code{\link[R6:R6Class]{R6}} object of
class \code{\link{Text}}.

\code{\link[=is_text]{is_text()}} returns a logical value.

\code{\link[=format]{format()}} returns a character vector.

\code{\link[=print]{print()}} returns argument \code{x} invisibly.

\code{\link[=merge_texts]{merge_texts()}} returns a list of (combined) \code{\link{Text}} objects. It
can be empty if all underlying \code{\link{Text}} objects are empty.
}
\description{
Structure a source text and its translations.
}
\details{
A \code{\link{Text}} object is a piece of text that is extracted from \R source
scripts.
\itemize{
\item It (typically) has one or more \code{\link[=Location]{Locations}} within a project.
\item It is complemented by any number of translations and further attributes.
}

The \code{\link{Text}} class structures this information and exposes a set of
methods to manipulate it.
\subsection{Combining Text Objects}{

\code{\link[=c]{c()}} can only combine \code{\link{Text}} objects having the same \code{hash}.
This is equivalent to having the same \code{algorithm}, \code{source_lang}, and
\code{source_text}. In that case, the underlying translations and
\code{\link{Location}} objects are combined and a new object is returned.
It throws an error if all \code{\link{Text}} objects are empty (they have no
set \code{source_lang}).

\code{\link[=merge_texts]{merge_texts()}} is a generalized version of \code{\link[=c]{c()}} that handles any number
of \code{\link{Text}} objects having possibly different hashes. It can be
viewed as a vectorized version of \code{\link[=c]{c()}}. It silently ignores and drops
all empty \code{\link{Text}} objects.
}

\subsection{Coercion}{

\code{\link[=as_text]{as_text()}} is an S3 generic function that attempts to coerce its argument
into a suitable \code{\link{Text}} object. \code{\link[=as_text.call]{as_text.call()}} is the method used
by \code{\link[=find_source]{find_source()}} to coerce a \code{\link{call}} object to a \code{\link{Text}}
object. While it \emph{can} be used, it should be avoided most of the time. Users
may extend it by defining their own methods.
}
}
\examples{
# Set source language.
language_source_set("en")

# Create Text objects.
txt1 <- text(
  location("a", 1L, 2L, 3L, 4L),
  location("a", 1L, 2L, 3L, 4L),
  location("b", 5L, 6L, 7L, 8L),
  location("c", c(9L, 10L), c(11L, 12L), c(13L, 14L), c(15L, 16L)),
  en = "Hello, world!",
  fr = "Bonjour, monde!",
  es = "¡Hola, mundo!")

txt2 <- text(
  location("a", 1L, 2L, 3L, 4L),
  en = "Hello, world!",
  fr = "Bonjour, monde!",
  es = "¡Hola, mundo!")

txt3 <- text(
  source_lang = "fr2",
  location("a", 5L, 6L, 7L, 8L),
  en  = "Hello, world!",
  fr2 = "Bonjour le monde!",
  es  = "¡Hola, mundo!")

is_text(txt1)

# Texts objects has a specific format.
# print() calls format() internally, as expected.
print(txt1)
print(txt2)
print(txt3)

# Combine Texts objects.
# c() throws an error if they do not have the same
# hash (same souce_text, source_lang, and algorithm).
c(txt1, txt2)

# Text objects with different hashes can be merged.
# This groups Text objects according to their hashes
# and calls c() on each group. It returns a list.
merge_texts(txt1, txt2, txt3)

# Objects can be coerced to a Text object with as_text(). Below is an
# example for call objects. This is for illustration purposes only,
# and the latter should not be used. It is worthwhile to note that this
# method is used internally by find_source(). Use this function instead.
translate_call <- str2lang("transltr::translate('Hello, world!')")
translate_loc  <- location("example in class-text", 2L, 32L, 2L, 68L)
as_text(translate_call, location = translate_loc)


## ------------------------------------------------
## Method `Text$new`
## ------------------------------------------------

# Consider using text() instead.
txt <- Text$new()

## ------------------------------------------------
## Method `Text$get_translation`
## ------------------------------------------------

txt <- Text$new()
txt$set_translation("en", "Hello, world!")

txt$get_translation("en")  ## Outputs "Hello, world!"
txt$get_translation("fr")  ## Outputs NULL

## ------------------------------------------------
## Method `Text$set_translation`
## ------------------------------------------------

# Register a pair of source_lang and source_text.
txt <- Text$new()
txt$set_translation("en", "Hello, world!")
txt$source_lang <- "en"

## ------------------------------------------------
## Method `Text$set_translations`
## ------------------------------------------------

txt <- Text$new()
txt$set_translations(en = "Hello, world!", fr = "Bonjour, monde!")

## ------------------------------------------------
## Method `Text$set_locations`
## ------------------------------------------------

txt <- Text$new()
txt$set_locations(
  location("a", 1L, 2L, 3L, 4L),
  location("a", 1L, 2L, 3L, 4L),
  location("b", 5L, 6L, 7L, 8L))

## ------------------------------------------------
## Method `Text$rm_translation`
## ------------------------------------------------

txt <- Text$new()
txt$set_translations(en = "Hello, world!", fr = "Bonjour, monde!")
txt$source_lang <- "en"

# Remove source_lang and source_text.
txt$source_lang <- "fr"
txt$rm_translation("en")

## ------------------------------------------------
## Method `Text$rm_location`
## ------------------------------------------------

txt <- Text$new()
txt$set_locations(
  location("a", 1L, 2L, 3L, 4L),
  location("b", 5L, 6L, 7L, 8L))

txt$rm_location("a")
}
\keyword{internal}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{hash}}{A non-empty and non-\link[base:NA]{NA} character string. A
reproducible hash generated from \code{source_lang} and \code{source_text},
and by using the algorithm specified by \code{algorithm}. It is used
as a unique identifier for the underlying \code{\link{Text}} object.

This is a \strong{read-only} field. It is automatically updated
whenever fields \code{source_lang} and/or \code{algorithm} are updated.}

\item{\code{algorithm}}{A non-empty and non-\link[base:NA]{NA} character string
equal to \code{"sha1"}, or \code{"utf8"}. The algorithm to use when hashing
source information for identification purposes.}

\item{\code{source_lang}}{A non-empty and non-\link[base:NA]{NA} character string. The
language of the (untranslated) source text.

A language is usually a code (of two or three letters) for a native
language name. While users retain full control over codes, it is best
to use language codes stemming from well-known schemes such as
\href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47}, or
\href{https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes}{ISO 639-1}.
Doing so maximizes portability and cross-compatibility between packages.}

\item{\code{source_text}}{A non-empty and non-\link[base:NA]{NA} character string. The
(untranslated) source text. This is a \strong{read-only} field.}

\item{\code{languages}}{A character vector. Registered language
codes. This is a \strong{read-only} field. Use methods below
to update it.}

\item{\code{translations}}{A named character vector. Registered
translations of \code{source_text}, including the latter. Names
correspond to \code{languages}. This is a \strong{read-only} field.
Use methods below to update it.}

\item{\code{locations}}{A list of \code{\link{Location}} objects giving
the location(s) of \code{source_text} in the underlying project. It
can be empty. This is a \strong{read-only} field. Use methods below
to update it.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Text-new}{\code{Text$new()}}
\item \href{#method-Text-get_translation}{\code{Text$get_translation()}}
\item \href{#method-Text-set_translation}{\code{Text$set_translation()}}
\item \href{#method-Text-set_translations}{\code{Text$set_translations()}}
\item \href{#method-Text-set_locations}{\code{Text$set_locations()}}
\item \href{#method-Text-rm_translation}{\code{Text$rm_translation()}}
\item \href{#method-Text-rm_location}{\code{Text$rm_location()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Text-new"></a>}}
\if{latex}{\out{\hypertarget{method-Text-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{\link{Text}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Text$new(algorithm = constant("algorithms"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{algorithm}}{A non-empty and non-\link[base:NA]{NA} character string
equal to \code{"sha1"}, or \code{"utf8"}. The algorithm to use when hashing
source information for identification purposes.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{\link[R6:R6Class]{R6}} object of class \code{\link{Text}}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Consider using text() instead.
txt <- Text$new()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Text-get_translation"></a>}}
\if{latex}{\out{\hypertarget{method-Text-get_translation}{}}}
\subsection{Method \code{get_translation()}}{
Extract a translation, or the source text.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Text$get_translation(lang = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lang}}{A non-empty and non-\link[base:NA]{NA} character string. The
underlying language.

A language is usually a code (of two or three letters) for a native
language name. While users retain full control over codes, it is best
to use language codes stemming from well-known schemes such as
\href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47}, or
\href{https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes}{ISO 639-1}
to maximize portability and cross-compatibility.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character string. \code{NULL} is returned if the requested
translation is not available.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{txt <- Text$new()
txt$set_translation("en", "Hello, world!")

txt$get_translation("en")  ## Outputs "Hello, world!"
txt$get_translation("fr")  ## Outputs NULL
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Text-set_translation"></a>}}
\if{latex}{\out{\hypertarget{method-Text-set_translation}{}}}
\subsection{Method \code{set_translation()}}{
Register a translation, or the source text.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Text$set_translation(lang = "", text = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lang}}{A non-empty and non-\link[base:NA]{NA} character string. The
underlying language.

A language is usually a code (of two or three letters) for a native
language name. While users retain full control over codes, it is best
to use language codes stemming from well-known schemes such as
\href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47}, or
\href{https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes}{ISO 639-1}
to maximize portability and cross-compatibility.}

\item{\code{text}}{A non-empty and non-\link[base:NA]{NA} character string. A
translation, or a source text.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method is also used to register \code{source_lang} and
\code{source_text} \strong{before} setting them as such. See Examples below.
}

\subsection{Returns}{
A \code{NULL}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Register a pair of source_lang and source_text.
txt <- Text$new()
txt$set_translation("en", "Hello, world!")
txt$source_lang <- "en"
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Text-set_translations"></a>}}
\if{latex}{\out{\hypertarget{method-Text-set_translations}{}}}
\subsection{Method \code{set_translations()}}{
Register one or more translations, and/or the source
text.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Text$set_translations(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Any number of named, non-empty, and non-\link[base:NA]{NA}
character strings.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method can be viewed as a vectorized version of
method \code{set_translation()}.
}

\subsection{Returns}{
A \code{NULL}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{txt <- Text$new()
txt$set_translations(en = "Hello, world!", fr = "Bonjour, monde!")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Text-set_locations"></a>}}
\if{latex}{\out{\hypertarget{method-Text-set_locations}{}}}
\subsection{Method \code{set_locations()}}{
Register one or more locations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Text$set_locations(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Any number of \code{\link{Location}} objects.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method calls \code{\link[=merge_locations]{merge_locations()}} to merge all
values passed to \code{...} together with previously registered
\code{\link{Location}} objects. The underlying registered
paths and/or ranges won't be duplicated.
}

\subsection{Returns}{
A \code{NULL}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{txt <- Text$new()
txt$set_locations(
  location("a", 1L, 2L, 3L, 4L),
  location("a", 1L, 2L, 3L, 4L),
  location("b", 5L, 6L, 7L, 8L))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Text-rm_translation"></a>}}
\if{latex}{\out{\hypertarget{method-Text-rm_translation}{}}}
\subsection{Method \code{rm_translation()}}{
Remove a registered translation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Text$rm_translation(lang = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lang}}{A non-empty and non-\link[base:NA]{NA} character string
identifying a translation to be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
You cannot remove \code{lang} when it is registered as the
current \code{source_lang}. You must update \code{source_lang} before
doing so.
}

\subsection{Returns}{
A \code{NULL}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{txt <- Text$new()
txt$set_translations(en = "Hello, world!", fr = "Bonjour, monde!")
txt$source_lang <- "en"

# Remove source_lang and source_text.
txt$source_lang <- "fr"
txt$rm_translation("en")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Text-rm_location"></a>}}
\if{latex}{\out{\hypertarget{method-Text-rm_location}{}}}
\subsection{Method \code{rm_location()}}{
Remove a registered location.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Text$rm_location(path = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A non-empty and non-\link[base:NA]{NA} character string
identifying a \code{\link{Location}} object to be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{NULL}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{txt <- Text$new()
txt$set_locations(
  location("a", 1L, 2L, 3L, 4L),
  location("b", 5L, 6L, 7L, 8L))

txt$rm_location("a")
}
\if{html}{\out{</div>}}

}

}
}
