% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weekend.r
\name{weekend}
\alias{weekend}
\title{Classify Dates as Weekday or Weekend}
\usage{
weekend(input_date)
}
\arguments{
\item{input_date}{A vector of \code{Date} or \code{POSIXct} objects to classify.}
}
\value{
A character vector with the classification for each date: either
"Weekday" or "Weekend".
}
\description{
This function classifies each date in a vector of dates as either "Weekday"
or "Weekend". The function returns "Weekday" for Monday to Friday and
"Weekend" for Saturday and Sunday.
}
\details{
The function checks if the \code{input_date} is a valid \code{Date} or
\code{POSIXct} object. It returns "Weekday" for dates that fall on Monday
through Friday and "Weekend" for dates that fall on Saturday or Sunday. If
the input is not of the correct class, the function will throw an error.
}
\examples{
# Example 1: Date of a weekend
weekend(as.Date("2025-01-18"))

# Example 2: Date of a weekday
weekend(as.Date("2025-01-15"))

# Example 3: Date of an invalid object
try(
weekend("2025-01-18") # This will throw an error
)

}
\author{
Nicolas Foss, Ed.D., MS
}
