% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateDiscreteDistributions.R
\name{Trivariate_LSDsim}
\alias{Trivariate_LSDsim}
\title{Simulates from the trivariate logarithmic series distribution}
\usage{
Trivariate_LSDsim(N, p1, p2, p3)
}
\arguments{
\item{N}{number of data points to be simulated}

\item{p1}{parameter \eqn{p1} of the trivariate logarithmic series distribution}

\item{p2}{parameter \eqn{p2} of the trivariate logarithmic series distribution}

\item{p3}{parameter \eqn{p3} of the trivariate logarithmic series distribution}
}
\value{
An \eqn{N \times 3} matrix with \eqn{N} simulated values from the
 trivariate logarithmic series distribution
}
\description{
Simulates from the trivariate logarithmic series distribution
}
\details{
The probability mass function of a random vector
 \eqn{X=(X_1,X_2,X_3)' } following the trivariate logarithmic series
 distribution with parameters \eqn{0<p_1, p_2, p_3<1} with
 \eqn{p:=p_1+p_2+p_3<1} is given by
 \deqn{P(X_1=x_1,X_2=x_2,X_3=x_3)=\frac{\Gamma(x_1+x_2+x_3)}{x_1!x_2!x_3!}
 \frac{p_1^{x_1}p_2^{x_2}p_3^{x_3}}{(-\log(1-p))},} for
 \eqn{x_1,x_2,x_3=0,1,2,\dots} such that \eqn{x_1+x_2+x_3>0}.

 The simulation proceeds in two steps: First, \eqn{X_1} is simulated from the
 modified logarithmic distribution with parameters \eqn{\tilde
 p_1=p_1/(1-p_2-p_3)} and \eqn{\delta_1=\log(1-p_2-p_3)/\log(1-p)}. Then we
 simulate \eqn{(X_2,X_3)'} conditional on \eqn{X_1}. We note that
 \eqn{(X_2,X_3)'|X_1=x_1} follows the bivariate logarithmic series
 distribution with parameters \eqn{(p_2,p_3)} when \eqn{x_1=0}, and the
 bivariate negative binomial distribution with parameters \eqn{(x_1,p_2,p_3)}
 when  \eqn{x_1>0}.
}
\examples{
set.seed(1)
p1 <- 0.15
p2 <- 0.25
p3 <- 0.55
N <- 100
#Simulate N realisations from the bivariate LSD
y <- Trivariate_LSDsim(N, p1, p2, p3)
}
