% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_duration.R
\name{mod_duration}
\alias{mod_duration}
\title{Calculate the modified duration of a bond}
\usage{
mod_duration(yields, maturity, format_out = "xts")
}
\arguments{
\item{yields}{a series of yields}

\item{maturity}{constant bond maturity in years}

\item{format_out}{xts or tibble}
}
\value{
A series of modified duration
}
\description{
Calculate the modified duration of a bond
}
\details{
This function is normally used in combination with total_return() to compute bond total returns.

The modified duration is the interest rate sensitivity of the price of bond.

\deqn{duration = \frac{1}{y_t}{z_t}^{2M}}{duration = 1/(y_t) * z_t^(2M)}

with

\deqn{z_t = 1+\frac{y_t}{2}}{z_t = 1 + y_t/2}

\eqn{M}{M} is the maturity in years (e.g. 10), \eqn{y_t}{y_t} is the yield at time \eqn{t}{t}.
}
