% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward.R
\name{noisy_or}
\alias{noisy_or}
\title{Calculating the probability of transition from multiple nodes to given node in the tree}
\usage{
noisy_or(hmm, prev_state, cur_state)
}
\arguments{
\item{hmm}{Object of class List given as output by \code{\link{initHMM}},}

\item{prev_state}{vector containing state variable values for the previous nodes}

\item{cur_state}{character denoting the state variable value for current node}
}
\value{
The Noisy_OR probability for the transition
}
\description{
Calculating the probability of transition from multiple nodes to given node in the tree
}
\examples{
tmat = matrix(c(0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0),
               5,5, byrow= TRUE ) #for "X" (5 nodes) shaped tree
hmmA = initHMM(c("P","N"),list(c("L","R")), tmat) #one feature with two discrete levels "L" and "R"
Transprob = noisy_or(hmmA,c("P","N"),"P") #for transition from P & N simultaneously to P
}
