% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip-methods.R
\name{addClade}
\alias{addClade}
\title{Add clade to tree}
\usage{
addClade(tree, id, clade)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{id}{tip/node ID in tree to which the clade will be added}

\item{clade}{\code{TreeMan} object}
}
\description{
Returns a tree with added clade
}
\details{
Add a \code{TreeMan} object to an existing \code{TreeMan}
object by specifying an ID at which to attach. If the id specified
is an internal node, then the original clade descending from that
node will be replaced. Before running, ensure no IDs are shared
between the \code{tree} and the \code{clade}, except for the IDs in the clade
of that tree that will be replaced.
Note, returned tree will not have a node matrix.
}
\examples{
library(treeman)
t1 <- randTree(100)
# extract a clade
cld <- getSubtree(t1, 'n2')
# remove the same clade
t2 <- rmClade(t1, 'n2')
# add the clade again
t3 <- addClade(t2, 'n2', cld)
# t1 and t3 should be the same
# note there is no need to remove a clade before adding
t3 <- addClade(t1, 'n2', cld)  # same tree
}
\seealso{
\code{\link{rmClade}}, \code{\link{getSubtree}},
\url{https://github.com/DomBennett/treeman/wiki/manip-methods}
}
