% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query}
\alias{query}
\title{Queries}
\usage{
query(language, source)
}
\arguments{
\item{language}{\verb{[tree_sitter_language]}

A language.}

\item{source}{\verb{[string]}

A query source string.}
}
\value{
A query.
}
\description{
\code{query()} lets you specify a query \code{source} string for use with
\code{\link[=query_captures]{query_captures()}} and \code{\link[=query_matches]{query_matches()}}. The \code{source} string is written
in a way that is somewhat similar to the idea of capture groups in regular
expressions. You write out a pattern that matches a node in a tree, and then
you "capture" parts of that pattern with \verb{@name} tags. The captures are
the values returned by \code{\link[=query_captures]{query_captures()}} and \code{\link[=query_matches]{query_matches()}}. There are
also a series of \emph{predicates} that can be used to further refine the
query. Those are described in the \code{\link[=query_matches]{query_matches()}} help page.

Read the \href{https://tree-sitter.github.io/tree-sitter/using-parsers#query-syntax}{tree-sitter documentation}
to learn more about the query syntax.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# This query looks for binary operators where the left hand side is an
# identifier named `fn`, and the right hand side is a function definition.
# The operator can be `<-` or `=` (technically it can also be things like
# `+` as well in this example).
source <- '(binary_operator
  lhs: (identifier) @lhs
  operator: _ @operator
  rhs: (function_definition) @rhs
  (#eq? @lhs "fn")
)'

language <- treesitter.r::language()

query <- query(language, source)

text <- "
  fn <- function() {}
  fn2 <- function() {}
  fn <- 5
  fn = function(a, b, c) { a + b + c }
"
parser <- parser(language)
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

query_matches(query, node)
\dontshow{\}) # examplesIf}
}
