% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bartels.test.R
\name{bartels.test}
\alias{bartels.test}
\title{Bartels test for Randomness}
\usage{
bartels.test(x)
}
\arguments{
\item{x}{a vector of class "numeric" or a time series object of class "ts"}
}
\value{
A list with class "htest"

\item{data.name}{character string that denotes the input data}
\item{p.value}{the p-value}
\item{statistic}{the test statistic}
\item{alternative}{the alternative hypothesis}
\item{method}{character string that denotes the test}
}
\description{
Performes a rank version of von Neumann's ratio test as proposed by
Bartels. The null hypothesis of randomness is tested against the
alternative hypothesis
}
\details{
In this function, the test is implemented as given by Bartels (1982),
where the ranks \eqn{r_1, \ldots, r_n}{r[1], ..., r[n]} of
the \eqn{X_i, \ldots, X_n}{X[i], ..., X[n]} are used for the statistic:

\deqn{
T = \frac{\sum_{i=1}^n (r_i - r_{i+1})^2}{\sum_{i=1}^n (r_i - \bar{r})^2}
}{%
T = \sum_{i=1}^n (r[i] - r[i+1])^2 / \sum(r[i] - meanr)^2 }

As proposed by Bartels (1982), the \eqn{p}-value is calculated
for sample sizes in the range of \eqn{(10 \le n < 100)}{(10 <= n < 100)} with
the non-standard beta distribution for the range \eqn{0 \le x \le 4}{0 <= x <= 4}
with parameters:

\deqn{
 a = b = \frac{5 n \left( n + 1\right) \left(n - 1\right)^2}
         {2 \left(n - 2\right)  \left(5n^2 - 2n - 9\right)} - \frac{1}{2}
}{%
 a = b = 5 * n * ( n + 1) * (n - 1)^2 /
           (2 * ( n - 2) * (5 * n^2 - 2 * n - 9)) - 1/2
}

For sample sizes \eqn{n \ge 100}{n >= 100} a normal approximation with
\eqn{N(2, 20/(5n + 7))} is used for \eqn{p}-value calculation.
}
\note{
The current function is for complete observations only.
}
\examples{
# Example from Schoenwiese (1992, p. 113)
## Number of frost days in April at Munich from 1957 to 1968
## 
frost <- ts(data=c(9,12,4,3,0,4,2,1,4,2,9,7), start=1957)
bartels.test(frost)

## Example from Sachs (1997, p. 486)
x <- c(5,6,2,3,5,6,4,3,7,8,9,7,5,3,4,7,3,5,6,7,8,9)
bartels.test(x)

## Example from Bartels (1982, p. 43)
x <- c(4, 7, 16, 14, 12, 3, 9, 13, 15, 10, 6, 5, 8, 2, 1, 11, 18, 17)
bartels.test(x)
 
}
\references{
R. Bartels (1982), The Rank Version of von Neumann's Ratio Test
for Randomness, \emph{Journal of the American Statistical Association}
77, 40--46.
}
\seealso{
\code{\link{ww.test}},
\code{\link{wm.test}}
}
\concept{
von-Neumann
}
\keyword{{htest}}
\keyword{{nonparametric}}
\keyword{{ts}}
\keyword{{univar}}
