% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{as.Other}
\alias{as.Other}
\alias{as.psp.trip}
\alias{as.track_xyt.trip}
\alias{as.ppp}
\alias{as.psp}
\alias{as.ppp.trip}
\alias{explode}
\title{As ("trip", other-classes)}
\usage{
\method{as.ppp}{trip}(X, ..., fatal)

\method{as.psp}{trip}(x, ..., from, to)

as.track_xyt.trip(x, ..., from, to)

explode(x, ...)
}
\arguments{
\item{X}{\code{trip} object.}

\item{...}{reserved for future methods}

\item{fatal}{Logical value, see Details of \code{\link[spatstat.geom]{as.ppp}}}

\item{x}{\code{trip} object}

\item{from}{see \code{\link[spatstat.geom]{as.psp}} for that method.}

\item{to}{See \code{\link[spatstat.geom]{as.psp}}.}
}
\value{
ppp object

psp object

SpatialLinesDataFrame

SpatialLinesDataFrame object with each individual line segment identified by start/end time and trip ID
}
\description{
Coercing \code{trip} objects to other classes.

Function to create a SpatialLinesDataFrame from a trip object, resulting in
a line segment for each implicit segment along the tracks. The object stores
the start and end times, duration and the ID of the segment.
}
\examples{
d <- data.frame(x=1:10, y=rnorm(10), tms=Sys.time() + 1:10, id=gl(2, 5))
sp::coordinates(d) <- ~x+y
tr <- trip(d, c("tms", "id"))

as(tr, "ppp")
d <- data.frame(x=1:10, y=rnorm(10), tms=Sys.time() + 1:10, id=gl(2, 5))
tr <- trip(d, c("tms", "id"))

 as(tr, "psp")
 as.psp(tr)
 d <- data.frame(x=1:10, y=rnorm(10), tms=Sys.time() + 1:10, id=gl(2, 5))
 tr <- trip(d)

spldf <- explode(tr)
summary(tr)
}
