% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivarts.r
\name{bispeces}
\alias{bispeces}
\title{\code{bispeces} performs indirect bivariate spectral estimation of two series y1, y2 using lagwindows}
\usage{
bispeces(y1, y2, q, win = "bartlett")
}
\arguments{
\item{y1}{vector, the first time series}

\item{y2}{vector, the second time series}

\item{q}{number of covariances used for indirect spectral estimation}

\item{win}{lagwindow  (possible: "bartlett", "parzen", "tukey")}
}
\value{
out  data frame with columns:
\item{f}{frequencies 0, 1/n, 2/n, ...  (<= 1/2 )  }
\item{coh}{estimated coherency at Fourier frequencies 0,1/n, ...}
\item{ph}{estimated phase at Fourier frequencies 0,1/n, ...}
}
\description{
\code{bispeces} performs indirect bivariate spectral estimation of two series y1, y2 using lagwindows
}
\examples{
data(ICECREAM)
y <- ICECREAM
out <- bispeces(y[,1],y[,2],8,win="bartlett") 
}
