% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/armacopula.R
\name{kfilter}
\alias{kfilter}
\title{Kalman filter for ARMA copula model}
\usage{
kfilter(x, y)
}
\arguments{
\item{x}{an object of class \linkS4class{armacopula}.}

\item{y}{a vector of data.}
}
\value{
A matrix or multivariate time series with columns consisting of
conditional mean, standard deviation and residuals.
}
\description{
Kalman filter for ARMA copula model
}
\examples{
data <- sim(armacopula(list(ar = c(0.5, 0.4), ma = -0.8)), n = 1000)
kfilter(armacopula(list(ar = c(0.5, 0.4), ma = -0.8)), data)
}
