% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specification.R
\name{distribution_modelspec}
\alias{distribution_modelspec}
\title{Specification of distribution model}
\usage{
distribution_modelspec(y, distribution = "norm", ...)
}
\arguments{
\item{y}{a numeric vector}

\item{distribution}{the type of distribution. Valid choices are norm (Normal),
snorm (Skew Normal), std (Student), sstd (Skew Student), ged (Generalized Error),
sged (Skew Generalized Error), nig (Normal Inverse Gaussian), gh (Generalized Hyperbolic),
ghst (Generalized Hyperbolic Skew Student) and jsu (Johnson's SU).}

\item{...}{not currently used}
}
\value{
An object of class \dQuote{tsdistribution.spec}
}
\description{
Specification of distribution model
}
\details{
All distributions are parameterized in terms of their mean (\sQuote{mu}), standard deviation
\sQuote{sigma}, skew \sQuote{skew} and shape \sQuote{shape} parameters. Additionally,
for the Generalized Hyperbolic distribution, there is an extra shape parameter
\dQuote{lambda} arising from the GIG mixing distribution.
Parameters can be fixed post initialization by setting setting specific values
to the \sQuote{value} column in the parmatrix table and setting the \sQuote{estimate}
variable to 0 (instead of 1).
}
\examples{
spec <- distribution_modelspec(rnorm(1000), distribution = "gh")
# fix lambda and shape
spec$parmatrix[parameter == 'lambda', value := 30]
spec$parmatrix[parameter == 'lambda', estimate := 0]
}
