% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.r
\name{DETS}
\alias{DETS}
\title{Dynamic Ensemble for Time Series}
\usage{
DETS(form, data, specs, lambda = 50, omega = 0.5,
  select_best = FALSE, num_cores = 1)
}
\arguments{
\item{form}{formula;}

\item{data}{data frame to train the base models;}

\item{specs}{object of class \code{\link{model_specs-class}}. Contains
the parameter setting information for training the
base models;}

\item{lambda}{window size. Number of observations to compute
the recent performance of the base models, according to the
committee ratio \strong{omega}. Essentially, the top \emph{omega}
models are selected and weighted at each prediction instance, according
to their performance in the last \emph{lambda} observations.
Defaults to 50 according to empirical experiments;}

\item{omega}{committee ratio size. Essentially, the top \emph{omega}
models are selected and weighted at each prediction instance, according
to their performance in the last \emph{lambda} observations.
Defaults to .5 according to empirical experiments;}

\item{select_best}{Logical. If true, at each prediction time,
a single base model is picked to make a prediction. The picked
model is the one that has the lowest loss prediction from
the meta models. Defaults to FALSE;}

\item{num_cores}{A numeric value to specify the number of cores used to
train base and meta models. num_cores = 1
leads to sequential training of models. num_cores > 1
splits the training of the base models across num_cores cores.}
}
\description{
A Dynamic Ensemble for Time Series (DETS). The DETS ensemble
method we present settles on individually pre-trained models
which are dynamically combined at run-time to make a prediction.
The combination rule is reactive to changes in the environment,
rendering an online combined model. The main properties of the ensemble
are:
\describe{
 \item{heterogeneity}{Heterogeneous ensembles are those
 comprised of different types of base learners. By employing
 models that follow different learning strategies, use different
 features and/or data observations we expect that individual
 learners will disagree with each other, introducing a natural
 diversity into the ensemble that helps in handling different
 dynamic regimes in a time series forecasting setting;}
 \item{responsiveness}{We promote greater responsiveness of
 heterogeneous ensembles in time series tasks by making the
 aggregation of their members' predictions time-dependent.
 By tracking the loss of each learner over time, we weigh
 the predictions of individual learners according to their
 recent performance using a non-linear function. This strategy
 may be advantageous for better detecting regime changes and
 also to quickly adapt the ensemble to new regimes.}
}
}
\examples{
specs <- model_specs(
 c("bm_ppr", "bm_svr"),
 list(bm_ppr = list(nterms = c(2, 4)),
      bm_svr = list(kernel = c("vanilladot", "polydot"), C = c(1,5)))
)

data("water_consumption");
train <- embed_timeseries(water_consumption, 5);

model <- DETS(target ~., train, specs, lambda = 30, omega = .2)

}
\references{
Cerqueira, Vitor; Torgo, Luis; Oliveira, Mariana,
and Bernhard Pfahringer. "Dynamic and Heterogeneous Ensembles
for Time Series Forecasting." Data Science and Advanced
Analytics (DSAA), 2017 IEEE International Conference on. IEEE, 2017.
}
\seealso{
\code{\link{model_specs-class}} for setting up the ensemble parameters
for an \strong{DETS} model; \code{\link{forecast}} for the method
that uses an \strong{DETS} model for forecasting future values;
\code{\link{predict}} for the method that predicts new held out observations;
\code{\link{update_weights}} for the method used to update the
weights of an \strong{DETS} model between successive predict or forecast calls;
\code{\link{update_base_models}} for the updating (retraining)
the base models of an \strong{DETS} ensemble (and respective
weights); and \code{\link{dets_hat-class}} for the object that results from
predicting with an \strong{DETS} model.
}
