% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-methods.r
\docType{methods}
\name{predict}
\alias{predict}
\alias{predict.ade}
\alias{predict.dets}
\alias{predict.base}
\alias{predict,ADE-method}
\alias{predict,DETS-method}
\alias{predict,base_ensemble-method}
\title{Predicting new observations using an ensemble}
\usage{
\S4method{predict}{ADE}(object, newdata)

\S4method{predict}{DETS}(object, newdata)

\S4method{predict}{base_ensemble}(object, newdata)
}
\arguments{
\item{object}{an object of class \code{\link{ADE-class}};}

\item{newdata}{new data to predict}
}
\description{
Initially, the predictions of the base models are collected.
Then, the predictions of the loss to be incurred by the base models \strong{E_hat}
(estimated by their associate meta models) are computed. The weights of
the base models are then estimated according to \strong{E_hat} and the committee of
top models. The committee is built according to the \emph{lambda} and
\emph{omega} parameters. Finally, the predictions are combined
according to the weights and the committee setup.
}
\examples{

###### Predicting with an ADE ensemble

specs <- model_specs(
 learner = c("bm_glm", "bm_mars"),
 learner_pars = NULL
)

data("water_consumption")
dataset <- embed_timeseries(water_consumption, 5)
train <- dataset[1:1000, ]
test <- dataset[1001:1500, ]

model <- ADE(target ~., train, specs)

preds <- predict(model, test)


\dontrun{

###### Predicting with a DETS ensemble

specs <- model_specs(
 learner = c("bm_svr", "bm_glm", "bm_mars"),
 learner_pars = NULL
)

data("water_consumption")
dataset <- embed_timeseries(water_consumption, 5)
train <- dataset[1:700, ]
test <- dataset[701:1000, ]

model <- DETS(target ~., train, specs, lambda = 50, omega = .2)

preds <- predict(model, test)
}


\dontrun{
###### Predicting with a base ensemble

model <- ADE(target ~., train, specs)

basepreds <- predict(model@base_ensemble, test)
}


}
