% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{entropy}
\alias{entropy}
\title{Spectral entropy of a time series}
\usage{
entropy(x)
}
\arguments{
\item{x}{a univariate time series}
}
\value{
A non-negative real value for the spectral entropy \eqn{H_s(x_t)}.
}
\description{
Computes spectral entropy from a univariate normalized
spectral density, estimated using an AR model.
}
\details{
The \emph{spectral entropy} equals the Shannon entropy of the spectral density
\eqn{f_x(\lambda)} of a stationary process \eqn{x_t}:
\deqn{ 
H_s(x_t) = - \int_{-\pi}^{\pi} f_x(\lambda) \log f_x(\lambda) d \lambda, 
}
where the density is normalized such that
\eqn{\int_{-\pi}^{\pi} f_x(\lambda) d \lambda = 1}.
An estimate of \eqn{f(\lambda)} can be obtained using \code{\link[stats]{spec.ar}} with
the \code{burg} method.
}
\examples{
entropy(rnorm(1000))
entropy(lynx)
entropy(sin(1:20))
}
\references{
Jerry D. Gibson and Jaewoo Jung (2006). \dQuote{The
Interpretation of Spectral Entropy Based Upon Rate Distortion Functions}.
IEEE International Symposium on Information Theory, pp. 277-281.

Goerg, G. M. (2013). \dQuote{Forecastable Component Analysis}.
Journal of Machine Learning Research (JMLR) W&CP 28 (2): 64-72, 2013.
Available at \url{http://jmlr.org/proceedings/papers/v28/goerg13.html}.
}
\seealso{
\code{\link[stats]{spec.ar}}
}
\author{
Rob J Hyndman
}
