% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_ma.R
\name{ts_fil_ma}
\alias{ts_fil_ma}
\title{Time Series Moving Average}
\usage{
ts_fil_ma(ma = 3)
}
\arguments{
\item{ma}{moving average size}
}
\value{
a \code{ts_fil_ma} object.
}
\description{
Used to smooth out fluctuations and reduce noise in a time series.
}
\examples{
# time series with noise
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2*tsd$y[9]

# filter
filter <- ts_fil_ma(3)
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# plot
plot_ts_pred(y=tsd$y, yadj=y)
}
