% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqplot.R
\name{qqgh}
\alias{qqgh}
\title{Draw a Q-Q plot based on g-and-h distribution}
\usage{
qqgh(x, theta = NULL, qqline = TRUE, grid = TRUE, ...)
}
\arguments{
\item{x}{either data as a \code{numeric} vector, or an object of class \code{fitGH},
as returned by \code{\link[=fitGH]{fitGH()}}.}

\item{theta}{parameters of the g-and-h distribution as a \code{numeric} vector of
length four: \eqn{(a, b, g, h)}. If argument \code{x} is a \code{fitGH} object,
and argument \code{theta} is \code{NULL}, \code{theta} will be initialised with \code{coef(x)}.}

\item{qqline}{if \code{TRUE} (default) a Q-Q line will be added to the graph by
means of \code{\link[=qqline]{qqline()}}}

\item{grid}{if \code{TRUE} (default) a Q-Q line will be added to the graph by
means of \code{\link[=grid]{grid()}}.}

\item{...}{other arguments passed to \code{\link[=qqplot]{qqplot()}}.}
}
\value{
A named list with the following components:
\itemize{
\item \code{teo_quantile}: theoretical quantile function (with argument \code{p})
\item \code{qqplot}: output of function \code{\link[=qqplot]{qqplot()}}
}
}
\description{
Draw a quantile-quantile plot based on the Tukey's g-and-h distribution.
}
\examples{
data("EPWS2014")
modII <- fitGH(EPWS2014)
qqgh(modII)

}
