% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tvsystem.R
\name{plot.tvsure}
\alias{plot.tvsure}
\alias{plot.tvlm}
\alias{plot.tvar}
\alias{plot.tvvar}
\alias{plot.tvirf}
\title{Plot Methods for objects in tvReg}
\usage{
\method{plot}{tvsure}(x, eqs = NULL, vars = NULL, ...)

\method{plot}{tvlm}(x, ...)

\method{plot}{tvar}(x, ...)

\method{plot}{tvvar}(x, ...)

\method{plot}{tvirf}(x, obs.index = NULL, impulse = NULL, response = NULL,
  plot.type = c("multiple", "single"), names = NULL, main = NULL,
  sub = NULL, ylab = NULL, xlab = NULL, nc, mar.multi = c(0, 4, 0, 4),
  oma.multi = c(6, 4, 6, 4), adj.mtext = NA, padj.mtext = NA, ...)
}
\arguments{
\item{x}{An x used to select a method.}

\item{eqs}{Character vector (optional) with the equation(s) number(s) or
equation name(s) of the coefficients to be plotted.}

\item{vars}{Character vector (optional) with the variable number(s) or
variable name(s) of the coefficients to be plotted.}

\item{...}{Other parameters passed to specific methods.}

\item{obs.index}{Scalar (optional), the time at which the impulse response is plotted.
If left NULL, the mean over the whole period is plotted (this values should be similar to
the estimation using a non time-varying VAR method).}

\item{impulse}{Character  vector (optional) of the impulses, default is all variables.}

\item{response}{Character vector (optional) of the responses, default is all variables.}

\item{plot.type}{Character, if multiple all plots are drawn in a single device,
otherwise the plots are shown consecutively.}

\item{names}{Character vector (optional), the variables names to be plotted.
If left NULL, all variables are plotted.}

\item{main}{Character vector, the titles of the plot.}

\item{sub}{Character, sub title in plot.}

\item{ylab}{Character vector signifying the labels for the y-axis.}

\item{xlab}{Character vector signifying the labels for the x-axis.}

\item{nc}{Integer, number of columns for multiple plot.}

\item{mar.multi}{Setting of margins, if plot.type = "multiple".}

\item{oma.multi}{Setting of margins, if plot.type = "multiple".}

\item{adj.mtext}{Adjustment for mtext(), only applicable if plot.type = "multiple".}

\item{padj.mtext}{Adjustment for mtext(), only applicable if plot.type = "multiple".}
}
\description{
Plot methods for objects with class attribute \code{tvlm}, \code{tvar}, \code{tvvar},
\code{tvirf}, \code{tvsure}.
}
\seealso{
\code{\link{tvLM}}, \code{\link{tvAR}}, \code{\link{tvVAR}},
\code{\link{tvSURE}}
}
