% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mechanisms.R
\name{est_ipcw}
\alias{est_ipcw}
\title{Estimate Inverse Probability of Censoring Weights}
\usage{
est_ipcw(V, Delta, fit_type = c("sl", "glm"), sl_learners = NULL)
}
\arguments{
\item{V}{A \code{numeric} vector, \code{matrix}, \code{data.frame} or
similar object giving the observed values of the covariates known to
potentially inform the censoring mechanism.}

\item{Delta}{A \code{numeric} vector giving observed values of the indicator
function corresponding to the censoring mechanism.}

\item{fit_type}{A \code{character} indicating whether to perform the fit
using GLMs or a Super Learner. If use of Super Learner is desired, then the
argument \code{sl_learners} must be provided.}

\item{sl_learners}{An \code{\link[sl3]{Lrnr_sl}} object, a Super Learner
instantiated externally using \pkg{sl3}.}
}
\value{
A \code{list} containing a \code{numeric} vector corresponding to
 the inverse probability of censoring weights required for computing an
 IPCW-TMLE and \code{numeric} vector of the estimated missingness mechanism.
 Formally, the former is nothing more than %\frac{\Delta}{\Pi_n}, where the
 term %\Pi_n is simply the predicted probability of belonging to a censoring
 class as computed using standard logistic regression.
}
\description{
Estimate Inverse Probability of Censoring Weights
}
\details{
Compute inverse probability of censoring weights for the two-phase
 sampling mechanism. These inverse weights are based on the probability of
 appearing in the second-phase sample based on variables measured on all
 participants.
}
