% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosaic_chunk.R
\name{mosaic_chunk}
\alias{mosaic_chunk}
\title{Mosaic chunk}
\usage{
mosaic_chunk(info, dmdfile)
}
\arguments{
\item{info}{\code{\link[=SpectralInfo-class]{SpectralInfo}} object.}

\item{dmdfile}{tarjet .dmd file to read.}
}
\value{
A \code{\link[=Tile-class]{Tile}} object.
}
\description{
The function read a single mosaic tile (.dmd file extension) using a \code{\link[=SpectralInfo-class]{SpectralInfo}} object as a guide to find the file. It returns an object of class \code{\link[=Tile-class]{Tile}}, which can be (pre/post)processed as if it were a single tile.
}
\examples{
x <- mosaic_info(base::system.file("extdata/mosaic.dmt", package = "uFTIR"))
y <- mosaic_chunk(x, "mosaic_0000_0000.dmd")
class(y)
}
