% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMARconstructor.R
\name{swap_parametrization}
\alias{swap_parametrization}
\title{Swap the parametrization of object of class 'gsmar' defining a GMAR, StMAR, or G-StMAR model}
\usage{
swap_parametrization(gsmar, calc_std_errors = TRUE, custom_h = NULL)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{calc_std_errors}{should approximate standard errors be calculated?}

\item{custom_h}{A numeric vector with same the length as the parameter vector: i:th element of custom_h is the difference
used in central difference approximation for partial differentials of the log-likelihood function for the i:th parameter.
If \code{NULL} (default), then the difference used for differentiating overly large degrees of freedom parameters
is adjusted to avoid numerical problems, and the difference is \code{6e-6} for the other parameters.}
}
\value{
Returns an object of class \code{'gsmar'} defining the specified GMAR, StMAR, or G-StMAR model. If data is supplied,
 the returned object contains (by default) empirical mixing weights, some conditional and unconditional moments, and quantile
 residuals. Note that the first p observations are taken as the initial values so the mixing weights, conditional moments, and
 quantile residuals start from the p+1:th observation (interpreted as t=1).
}
\description{
\code{swap_parametrization} swaps the parametrization of object of class '\code{gsmar}'
 to \code{"mean"} if the current parametrization is \code{"intercept"}, and vice versa.
}
\details{
\code{swap_parametrization} is a convenient tool if you have estimated the model in
 "intercept"-parametrization but wish to work with "mean"-parametrization in the future,
 or vice versa. For example, approximate standard errors are readily available for
 parametrized parameters only.
}
\examples{
# Restricted G-StMAR-model with intercept paarametrization
params42gsr <- c(0.11, 0.03, 1.27, -0.39, 0.24, -0.17, 0.03, 1.01, 0.3, 2.03)
gstmar42r <- GSMAR(data=T10Y1Y, p=4, M=c(1, 1), params=params42gsr,
 model="G-StMAR", restricted=TRUE)
summary(gstmar42r)

# Swap to mean parametrization
gstmar42r <- swap_parametrization(gstmar42r)
summary(gstmar42r)
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distribution.	arXiv:2003.05221 [econ.EM].
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{iterate_more}}, \code{\link{get_gradient}},
 \code{\link{get_regime_means}}, \code{\link{swap_parametrization}}, \code{\link{stmar_to_gstmar}}
}
