% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateGSMAR.R
\name{simulate.gsmar}
\alias{simulate.gsmar}
\title{Simulate obsercations from GMAR, StMAR, and G-StMAR processes}
\usage{
\method{simulate}{gsmar}(
  object,
  nsim = 1,
  seed = NULL,
  ...,
  init_values = NULL,
  ntimes = 1,
  drop = TRUE
)
}
\arguments{
\item{object}{object of class \code{'gsmar'}, typically created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{nsim}{a positive integer specifying how many values (ahead from \code{init_values}) will be simulated.}

\item{seed}{an integer that specifies the seed for the random number generator. Ignored if \code{NULL}.}

\item{...}{currently not in use.}

\item{init_values}{a numeric vector with length \code{>=p} specifying the initial values for the simulation. The \strong{last}
element will be used as the initial value for the first lag, the second last element will be initial value for the second lag, etc.
If \code{NULL}, initial values will be simulated from the process's stationary distribution.}

\item{ntimes}{a positive integer specifying how many sets of simulations should be performed.}

\item{drop}{if \code{TRUE} (default) then the components of the returned list are coerced to lower dimension if \code{ntimes==1},
i.e., \code{$sample} and \code{$component} will be vectors and \code{$mixing_weights} will be matrix.}
}
\value{
If \code{drop==TRUE} and \code{ntimes==1} (default): \code{$sample} and \code{$component} are vectors
 and \code{$mixing_weights} is a (\code{nsim}\eqn{xM}) matrix. Otherwise, returns a list with...
  \describe{
    \item{\code{$sample}}{a size (\code{nsim}\eqn{x}\code{ntimes}) matrix containing the simulated values.}
    \item{\code{$component}}{a size (\code{nsim}\eqn{x}\code{ntimes}) matrix containing the information from which
     mixture component each value was generated from.}
    \item{\code{$mixing_weights}}{a size (\code{nsim}\eqn{xMx}\code{ntimes}) array containing the mixing weights corresponding to the
     sample: the dimension \code{[i, , ]} is the time index, the dimension \code{[, i, ]} indicates the regime, and the dimension
     \code{[, , i]} indicates the i:th set of simulations.}
  }
}
\description{
\code{simulate.gsmar} simulates observations from the specified GMAR, StMAR, or G-StMAR process.
 Can be utilized for forecasting future values of the process.
}
\details{
The argument \code{ntimes} is intended for forecasting: a GSMAR process can be forecasted by simulating its
 possible future values. One can perform a large number of sets of simulations and calculate the sample quantiles from
 the simulated values to obtain prediction intervals. See the forecasting example below for a hand-on demonstration.
}
\examples{
set.seed(1)

# GMAR model:
params22 <- c(0.9, 0.4, 0.2, 0.5, 0.7, 0.5, -0.2, 0.7, 0.7)
mod22 <- GSMAR(p=2, M=2, params=params22, model="GMAR")
mysim <- simulate(mod22, nsim=500)
ts.plot(mysim$sample)
ts.plot(mysim$component)
ts.plot(mysim$mixing_weights, col=rainbow(2), lty=2)


# G-StMAR model, with initial values:
params42gs <- c(0.04, 1.34, -0.59, 0.54, -0.36, 0.01, 0.06, 1.28, -0.36,
                0.2, -0.15, 0.04, 0.19, 9.75)
gstmar42 <- GSMAR(data=M10Y1Y, p=4, M=c(1, 1), params=params42gs,
                  model="G-StMAR")
sim42gs <- simulate(gstmar42, nsim=500, init_values=1:4)
ts.plot(sim42gs$sample)
ts.plot(sim42gs$component)
ts.plot(sim42gs$mixing_weights, col=rainbow(2), lty=2)


# FORECASTING EXAMPLE:
# GMAR model, 1000 sets of simulations with initial values from the data:
params12 <- c(1.70, 0.85, 0.30, 4.12, 0.73, 1.98, 0.63)
gmar12 <- GSMAR(data=simudata, p=1, M=2, params=params12, model="GMAR")
sim12 <- simulate(gmar12, nsim=5, init_val=gmar12$data, ntimes=1000)
apply(sim12$sample, MARGIN=1, FUN=median) # Point prediction
apply(sim12$sample, MARGIN=1, FUN=quantile, probs=c(0.025, 0.975)) # 95\% pi
apply(sim12$mixing_weights, MARGIN=1:2, FUN=median) # mix.weight point pred
apply(sim12$mixing_weights, MARGIN=1:2, FUN=quantile,
      probs=c(0.025, 0.975)) # mix.weight 95\% prediction intervals
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}(2), 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2023. A mixture autoregressive model based on Student's t-distribution.
         \emph{Communications in Statistics - Theory and Methods}, \strong{52}(2), 499-515.
   \item Virolainen S. 2022. A mixture autoregressive model based on Gaussian and Student's t-distributions.
         Studies in Nonlinear Dynamics & Econometrics, \strong{26}(4) 559-580.
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{predict.gsmar}},
 \code{\link{add_data}}, \code{\link{cond_moments}}, \code{\link{mixing_weights}}
}
