% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_pc3D_dtm.R
\name{pc3D_dtm}
\alias{pc3D_dtm}
\title{create a Digital Terrain Model from preclassified point cloud data}
\usage{
pc3D_dtm(lasDir = NULL, gisdbasePath = NULL, thinGrid = "0.5",
  keepClass = "2", bulge = "1.5", splineNumber = "4",
  stepSize = "city", subSize = "ultra_fine", gridSize = "0.25",
  dtmarea = FALSE, cutExtent = NULL, projsubFolders = c("data/",
  "output/", "run/", "las/"),
  proj4 = "+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs",
  cores = "3", pathLastools = NULL, giLinks = NULL, MP = "~",
  verbose = FALSE)
}
\arguments{
\item{lasDir}{character. default is \code{NULL} path  to the laz/las file(s)}

\item{gisdbasePath}{character. default is \code{NULL} root directory of the project. NOTE the function creates two subfolder named \code{run} and \code{output}}

\item{thinGrid}{numerical. default 0.5 meter. Grid stepsize for data thinning}

\item{keepClass}{numerical. default is 2. Default ground class of las/laz conform data}

\item{bulge}{numerical. default is 1.5. 'A parameter to filter spikes it is set to a stepSize/10 and then clamped into the range from 1.0 to 2.0}

\item{splineNumber}{numerical. default is 3, Maximum number of spline iterations highly suggested to take odd numbers. As higher as more detailed (spurious).}

\item{stepSize}{character. default is 25 meter. lastools key words if \code{city},\code{town},\code{metro},\code{nature},\code{wilderness} or experiment with free values}

\item{subSize}{= character. "8", default is 8 meter. lastools key words if \code{extra_coarse},\code{coarse},\code{fine},\code{extra_fine},\code{ultra_fine},\code{hyper_fine} or experiment with free values}

\item{gridSize}{numerical. resolution of the DTM raster}

\item{dtmarea}{logical. default \code{FALSE} generate polygon of valid DTM data}

\item{cutExtent}{object of typ extent deteerming the clip area}

\item{projsubFolders}{list of character contaiing subfolders that will be created/linked for R related GRASS processing}

\item{proj4}{default is EPSG 32632, any valid proj4 string that is assumingly the correct one}

\item{cores}{numerical. number of cores that will be used}

\item{pathLastools}{character. folder containing the Windows binary files of the lastools}

\item{giLinks}{list of GI tools cli pathes, default is NULL}

\item{MP}{character mounting point / drive letter default is "~"}

\item{verbose}{logical. to be quiet (1)}
}
\description{
Create a Digital Terrain Model from a high density point cloud as typically derived by an optical UAV retrieval.
}
\examples{
\dontrun{
require(uavRst)
require(link2GI)

# create and check the links to the GI software
giLinks<-list()
giLinks$saga<-link2GI::linkSAGA()
if (giLinks$saga$exist) {
# proj subfolders
projRootDir<-tempdir()
unlink(paste0(projRootDir,"*"), force = TRUE)
projsubFolders<-c("data/","data/ref/","output/","run/","las/")
paths<-link2GI::initProj(projRootDir = projRootDir,
                        projFolders = projsubFolders,
                        global = TRUE,
                        path_prefix = "path_")
setwd(paste0(projRootDir,"run"))
# get some colors
pal = mapview::mapviewPalette("mapviewTopoColors")

# get the data
utils::download.file(url="https://github.com/gisma/gismaData/raw/master/uavRst/data/lidar.las",
                    destfile="lasdata.las")

# create a DSM  based on a uav point cloud
pc3DTM <- pc3D_dtm(lasDir =  "lasdata.las",
                      gisdbasePath = projRootDir,
                      projsubFolders = projsubFolders,
                      thinGrid = 1.,
                      splineNumber = 5 ,
                      gridSize = 0.5,
                      giLinks = giLinks)
mapview::mapview(pc3DTM[[1]]) 
}
}
}
\author{
Chris Reudenbach
}
