% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_view}
\alias{system_view}
\title{View Information About the System}
\usage{
system_view(cfg, field = "all")
}
\arguments{
\item{cfg}{ubiquity system object}

\item{field}{string indicating the aspect of the system to display}
}
\value{
sequence of strings with system in formation (one line per element)

The \code{field} 
\itemize{
   \item \code{"all"} will show all information about the system
   \item \code{"parameters"} summary of parameter information
   \item \code{"bolus"} currently set bolus dosing
   \item \code{"rate"} infusion rate dosing 
   \item \code{"covariate"} covariates
   \item \code{"iiv"} variance/covariance information
   \item \code{"datasets"} loaded datasets
   \item \code{"simulation"} simulation options
   \item \code{"estimation"} estimation options
}
}
\description{
Displays information (dosing, simulation options, covariates,
etc) about the system.
}
\examples{
# To log and display the current system information:
\donttest{
# Creating a system file from the mab_pk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "mab_pk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

vp(cfg, system_view(cfg))
}
}
