% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{workshop_fetch}
\alias{workshop_fetch}
\title{Fetch Ubiquity Workshop Sections}
\usage{
workshop_fetch(
  section = "Simulation",
  overwrite = FALSE,
  copy_files = TRUE,
  output_directory = getwd()
)
}
\arguments{
\item{section}{Name of the section of workshop to retrieve  ("Simulation")}

\item{overwrite}{if \code{TRUE} the new workshop files will overwrite any existing files present (\code{FALSE})}

\item{copy_files}{if \code{TRUE} the files will be written to the output_directory, if \code{FALSE} only the names and locations of the files will be returned (\code{TRUE})}

\item{output_directory}{directory where workshop files will be placed (getwd())}
}
\value{
list
}
\description{
With the ubiquity package this function can be used to fetch
example files for different sections of the workshop.
}
\details{
Valid sections are "Simulation", "Estimation", "Titration" "Reporting", and "NCA"
}
\examples{
\donttest{
workshop_fetch("Estimation", output_directory=tempdir(), overwrite=TRUE)
}
}
