% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{md_to_officer}
\alias{md_to_officer}
\title{Parse Markdown for Officer}
\usage{
md_to_officer(
  str,
  default_format = list(color = "black", font.size = 12, bold = FALSE, italic = FALSE,
    underlined = FALSE, font.family = "Cambria (Body)", vertical.align = "baseline",
    shading.color = "transparent")
)
}
\arguments{
\item{str}{string containing Markdown can contain the following elements:
\itemize{
 \item paragraph:   two or more new lines creates a paragraph
 \item bold:        can be either \code{"*text in bold*"} or \code{"_text in bold_"}
 \item italics:     can be either \code{"**text in italics**"} or \code{"__text in italics__"}
 \item subscript:   \code{"Normal~subscript~"} 
 \item superscript: \code{"Normal^superscript^"} 
 \item color:       \code{"<color:red>red text</color>"} 
 \item shade:       \code{"<shade:#33ff33>shading</shade>"} 
 \item font family: \code{"<ff:symbol>symbol</ff>"} 
}}

\item{default_format}{list containing the default format for elements not defined with markdown default values. 
\preformatted{
   default_format = list( 
      color          = "black",
      font.size      = 12,
      bold           = FALSE,
      italic         = FALSE,
      underlined     = FALSE,
      font.family    = "Cambria (Body)",
      vertical.align = "baseline",
      shading.color  = "transparent")
}}
}
\value{
list with parsed paragraph elements ubiquity system object with the
content added to the body, each paragraph can be found in a numbered list
element (e.g. \code{pgraph_1}, \code{pgraph_2}, etc) each with the following
elements:
\itemize{
 \item \code{locs} Dataframe showing the locations of markdown elements in the current paragraph
 \item \code{pele} These are the individual parsed paragraph elements
 \item \code{fpar_cmd} String containing the fpar_cmd that can be run using
 \code{eval} to return the output of \code{fpar}. For example: 
\preformatted{
  myfpar = eval(parse(text=pgparse$pgraph_1$fpar_cmd))
 }
 \item \code{as_paragraph_cmd} String containing the as_paragraph_cmd that can be run using
\preformatted{
  myas_para = eval(parse(text=pgparse$pgraph_1$as_paragraph_cmd))
 }
}
}
\description{
Parses text in Markdown format and returns fpar and as_paragraph command strings to be used with Officer
}
