% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_set_bolus}
\alias{system_set_bolus}
\title{Set Bolus Inputs}
\usage{
system_set_bolus(cfg, state, times, values)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{state}{name of the state to apply the bolus}

\item{times}{list of injection times}

\item{values}{corresponding list injection values}
}
\value{
Ubiquity system object with the bolus information set
}
\description{
Defines infusion rates specified in the system file using  \code{<B:times>} and   \code{<B:events>}
}
\examples{
\donttest{
# Creating a system file from the mab_pk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "mab_pk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

# Clearing all inputs
cfg = system_zero_inputs(cfg)

# SC dose of 200 mg
cfg = system_set_bolus(cfg, state   ="At", 
                            times   = c(  0.0),  #  day
                            values  = c(200.0))  #  mg
}
}
\seealso{
\code{\link{system_zero_inputs}}
}
