% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_plot_cohorts}
\alias{system_plot_cohorts}
\title{Plot Estimation Results}
\usage{
system_plot_cohorts(
  erp,
  plot_opts = c(),
  cfg,
  analysis_name = "analysis",
  archive_results = TRUE,
  prefix = NULL
)
}
\arguments{
\item{erp}{output from \code{system_simulate_estimation_results}}

\item{plot_opts}{list controling how predictions and data are overlaid}

\item{cfg}{ubiquity system object}

\item{analysis_name}{string containing the name of the analysis}

\item{archive_results}{boolean variable to control whether results will be archived}

\item{prefix}{depreciated input mapped to analysis_name}
}
\value{
List of plot outputs containing two elements \code{timecourse} and
\code{obs_pred}, for the time course of and observed vs predicted,
respectively. Both of these fields contain three elements for a given
output. For example, say there is an output named \code{PK} the both the
\code{timecourse} and \code{obs_pred} elements will have a field named
\code{PK} containing a ggplot object
and two fields \code{PK_png} and \code{PK_pdf} containing the paths to the
files containing that figure in the respective formats.
}
\description{
Generates figures for each cohort/output for a given set of
parameter estimates.
}
\details{
The general format for a plot option for a given output (\code{OUTPUT}) is:

\code{plot_opts$outputs$OUTPUTt$option = value}

The following options are:
\itemize{
 \item \code{yscale} and  \code{xscale} \code{= "linear" or "log"}
 \item \code{ylabel} and  \code{xlabel} \code{= "text"}
 \item \code{xlim}   and  \code{ylim}   \code{= c(min, max)}
 }

It is also possible to control the \code{height} and \code{width} of the time course \code{tc} and observed vs predicted \code{op} file by specifying the following in the default units of \code{ggsave}.
\itemize{
 \item \code{plot_opts$tc$width  = 10}  
 \item \code{plot_opts$tc$height = 5.5} 
 \item \code{plot_opts$op$width  = 10}  
 \item \code{plot_opts$op$height = 8.0} 
 }

To control the figures that are generated you can set the purpose to either "print", "present" (default) or "shiny".

 \code{plot_opts$purpose = "present"}
}
\seealso{
The estimation vignette (\code{vignette("Estimation", package = "ubiquity")})
}
